/**
 * \file: main.c
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: authorization level daemon
 *
 * \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
 *
 * \copyright (c) 2010, 2011 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/
#include <stdio.h>

#include "ald_init.h"
#include "ald_types.h"


int main(int argc, char *argv[])
{
	error_code_t result;
    command_vtable_t *current_cmd = NULL;

	result=ald_init_init(argc ,argv, &current_cmd);
	if (result==RESULT_OK)
		result=ald_init_start(current_cmd);

	ald_init_deinit(current_cmd);

	if (result!=RESULT_OK && result!=RESULT_HELP_PRINTED)
	{
		ald_init_error_message(result);
		return 1;
	}

	return 0;
}
